/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine;

import com.mojang.blaze3d.matrix.MatrixStack;
import lib.toma.animations.engine.PositionConfig;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RenderConfig
extends PositionConfig {
    protected Vector3f scale;
    protected Quaternion rotation;

    protected RenderConfig(Vector3d position, Vector3f scale, Quaternion rotation) {
        super(position);
        this.scale = scale;
        this.rotation = rotation;
    }

    private RenderConfig(RenderConfigBuilder builder) {
        super(builder.pos);
        this.scale = builder.scale;
        this.rotation = builder.rotation;
    }

    public static RenderConfigBuilder newDef() {
        return new RenderConfigBuilder();
    }

    public Mutable toMutable() {
        return new Mutable(this.pos, this.scale, this.rotation);
    }

    @Override
    public void applyTo(MatrixStack stack) {
        super.applyTo(stack);
        stack.func_227862_a_(this.scale.func_195899_a(), this.scale.func_195900_b(), this.scale.func_195902_c());
        stack.func_227863_a_(this.rotation);
    }

    public static class RenderConfigBuilder {
        private Vector3d pos = Vector3d.field_186680_a;
        private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
        private Quaternion rotation = Quaternion.field_227060_a_;

        private RenderConfigBuilder() {
        }

        public RenderConfigBuilder withPosition(Vector3d position) {
            this.pos = position;
            return this;
        }

        public RenderConfigBuilder withPosition(double x, double y, double z) {
            return this.withPosition(new Vector3d(x, y, z));
        }

        public RenderConfigBuilder withScale(float scale) {
            return this.withScale(scale, scale, scale);
        }

        public RenderConfigBuilder withScale(Vector3f scale) {
            this.scale = scale;
            return this;
        }

        public RenderConfigBuilder withScale(float x, float y, float z) {
            return this.withScale(new Vector3f(x, y, z));
        }

        public RenderConfigBuilder withRotation(Quaternion rotation) {
            this.rotation = rotation;
            return this;
        }

        public RenderConfigBuilder flipY() {
            return this.withRotation(Vector3f.field_229181_d_.func_229193_c_((float)Math.PI));
        }

        public RenderConfig finish() {
            return new RenderConfig(this);
        }
    }

    public static class Mutable
    extends RenderConfig {
        public Mutable() {
            this(new Vector3d(0.0, 0.0, 0.0), new Vector3f(1.0f, 1.0f, 1.0f), Quaternion.field_227060_a_.func_227068_g_());
        }

        public Mutable(Vector3d position, Vector3f scale, Quaternion rotation) {
            super(position, scale, rotation);
        }

        public Vector3d getPosition() {
            return this.pos;
        }

        public Vector3f getScale() {
            return this.scale;
        }

        public Quaternion getRotation() {
            return this.rotation;
        }

        public void setPosition(Vector3d position) {
            this.pos = position;
        }

        public void setScale(Vector3f scale) {
            this.scale = scale;
        }

        public void setRotation(Quaternion rotation) {
            this.rotation = rotation;
        }

        public void toDefaults() {
            this.setPosition(new Vector3d(0.0, 0.0, 0.0));
            this.setScale(new Vector3f(1.0f, 1.0f, 1.0f));
            Quaternion quat = Quaternion.field_227060_a_.func_227068_g_();
            this.setRotation(quat);
        }

        @Override
        public Mutable toMutable() {
            return this;
        }

        public RenderConfig toImmutable() {
            return new RenderConfig(this.pos, this.scale, this.rotation);
        }
    }
}

